# Generated by default/object.tt
package Paws::DLM::EventSource;
  use Moose;
  has Parameters => (is => 'ro', isa => 'Paws::DLM::EventParameters');
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::DLM::EventSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DLM::EventSource object:

  $service_obj->Method(Att1 => { Parameters => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DLM::EventSource object:

  $result = $service_obj->Method(...);
  $result->Att1->Parameters

=head1 DESCRIPTION

Specifies an event that triggers an event-based policy.

=head1 ATTRIBUTES


=head2 Parameters => L<Paws::DLM::EventParameters>

Information about the event.


=head2 B<REQUIRED> Type => Str

The source of the event. Currently only managed AWS CloudWatch Events
rules are supported.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DLM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

