# Generated by default/object.tt
package Paws::DevOpsGuru::EventTimeRange;
  use Moose;
  has FromTime => (is => 'ro', isa => 'Str', required => 1);
  has ToTime => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::EventTimeRange

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::EventTimeRange object:

  $service_obj->Method(Att1 => { FromTime => $value, ..., ToTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::EventTimeRange object:

  $result = $service_obj->Method(...);
  $result->Att1->FromTime

=head1 DESCRIPTION

The time range during which an AWS event occurred. AWS resource events
and metrics are analyzed by DevOps Guru to find anomalous behavior and
provide recommendations to improve your operational solutions.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FromTime => Str

The time when the event started.


=head2 B<REQUIRED> ToTime => Str

The time when the event ended.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

