# Generated by default/object.tt
package Paws::Macie2::AccessControlList;
  use Moose;
  has AllowsPublicReadAccess => (is => 'ro', isa => 'Bool', request_name => 'allowsPublicReadAccess', traits => ['NameInRequest']);
  has AllowsPublicWriteAccess => (is => 'ro', isa => 'Bool', request_name => 'allowsPublicWriteAccess', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::AccessControlList

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::AccessControlList object:

  $service_obj->Method(Att1 => { AllowsPublicReadAccess => $value, ..., AllowsPublicWriteAccess => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::AccessControlList object:

  $result = $service_obj->Method(...);
  $result->Att1->AllowsPublicReadAccess

=head1 DESCRIPTION

Provides information about the permissions settings of the bucket-level
access control list (ACL) for an S3 bucket.

=head1 ATTRIBUTES


=head2 AllowsPublicReadAccess => Bool

Specifies whether the ACL grants the general public with read access
permissions for the bucket.


=head2 AllowsPublicWriteAccess => Bool

Specifies whether the ACL grants the general public with write access
permissions for the bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

