/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* parament.c
**
** ParamEntry();
**/

#include <string.h>
#include <stdlib.h>

#include "pfile.h"
#include "parament.h"

int
ParamAccess (ParamFile pfile, char *name)
{
  return ParamLookup (pfile->psets, name) != NULL;
}


int
ParamInfo (ParamFile pfile,
	   char *name, char *mode, char *type, char *value, char *min,
	   char *max, char *prompt)
{
  char xname[SZ_PFLINE];

  if (pfile == NULL)
    return 0;

  PParseName (name, xname);
  /* fprintf(stderr, "%s %s\n", name, xname); */

  return ParamEntry (&pfile, ParamLookup (pfile->psets, xname), NULL, mode,
		     type, value, min, max, prompt);
}

char *
ParamResolve (ParamFile pfile, char *name, char *str, int max)
{
  int mode = pfile->mode;
  void *value;
  if ((value = ParamGetX (pfile, name, StringType, &mode)))
    strncpy (str, value, max);
  else
    *str = '\0';
  return str;
}

int
ParamEntry (ParamFile * pf, Parameter * p, char *name, char *mode,
	    char *type, char *value, char *min, char *max, char *prompt)
{
  int got = 1;

  if (p == NULL)
    return 0;

/* fprintf(stderr, "Here X 1\n"); */
  if (name)
    strcpy (name, p->pname);
  if (mode)
    Convert (&p->pmode, ModeType, mode, StringType);
  if (type)
    Type2String (p->ptype, type);
  if (value)
    {
/* fprintf(stderr, "Here X X\n"); */
      if (p->pvalue.indir)
	{
	  strcpy (value, p->pvalue.indir);
	  got = 2;
	}
      else
	{
	  char c[1024];		/* Remember that only john can write code like this */

	  VConvert (&p->pvalue, value, StringType);
	  if (pf != NULL)
	    {
	      Value *v;
	      v = (Value *) calloc (1, sizeof (Value));
	      VNewValue (v, p->pvalue.value, p->pvalue.type);
	      if (IndirectClassing (*pf, p, v, c))
		{
		  VConvert (v, value, StringType);
		  got = 3;
		}
	      free ((char *) v);
	    }
	}
    }
  if (min)
    {
      if (p->pmin.indir)
	strcpy (min, p->pmin.indir);
      else
	VConvert (&p->pmin, min, StringType);
    }
  if (max)
    {
      if (p->pmax.indir)
	strcpy (max, p->pmax.indir);
      else
	VConvert (&p->pmax, max, StringType);
    }

  if (prompt)
    strcpy (prompt, p->pprompt ? p->pprompt : "");

  return got;
}
