# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Used by test cases in test__deprecate.py
"""

from neutron.common import _deprecate

from neutron.tests.unit.common import moved_globals_target

# a has been moved to moved_globals_target.a
b = 'barasingha'
# c has been renamed to d
d = 'capybara'
# e has been moved to moved_globals_target.f
g = 'gelada'

_deprecate._moved_global('c', new_name='d')
_deprecate._moved_global('e', new_name='f', new_module=moved_globals_target)

_deprecate._MovedGlobals(moved_globals_target)
