#include "Bdef.h"

void TransDist(ctxt, scope, m, n, rA, cA, ldrc, rdest, cdest)
BLACSCONTEXT  *ctxt;
char  scope;
int  m;
int  n;
int  *rA;
int  *cA;
int  ldrc;
int  rdest;
int  cdest;
/*
 *  This routine translates distances (offsets from the destination node),
 *  stored as shorts in the cA array, into row and column coordinates.
 */
{
   int i, j;
   int Ng, nprow, npcol, myrow, mycol;
   unsigned short *dist;

   if ( (n < 1) || (m < 1) ) return;
   if (rdest == -1) rdest = cdest = 0;
   Mgridinfo(ctxt, Ng, nprow, npcol, myrow, mycol);

   switch(scope)
   {
   case 'r':
      for (j = 0; j < n; j++)
      {
         dist = (unsigned short *) cA;
         for (i=m-1; i >= 0; i--)
	 {
	    rA[i] = myrow;
	    cA[i] = (int) (cdest + dist[i]) % npcol;
	 }
	 rA += ldrc;
	 cA += ldrc;
      }
      break;
   case 'c':
      for (j = 0; j < n; j++)
      {
         dist = (unsigned short *) cA;
         for (i=m-1; i >= 0; i--)
	 {
	    rA[i] = (int) (rdest + dist[i]) % nprow;
	    cA[i] = mycol;
	 }
	 rA += ldrc;
	 cA += ldrc;
      }
      break;
   case 'a':
      rdest = Mvkpnum(ctxt, rdest, cdest);  /* figure vdest from coordinates */
      for (j = 0; j < n; j++)
      {
         dist = (unsigned short *) cA;
         for (i=m-1; i >= 0; i--)
	 {
	    cdest = (int) (rdest + dist[i]) % Ng;    /* figure node number */
	    Mvpcoord(ctxt, cdest, rA[i], cA[i]);     /* figure node coordinates */
	 }
	 rA += ldrc;
	 cA += ldrc;
      }
      break;
   }
}
